require( "scripts/style.lua" );



TitleFont = {
  standardFont,
  30,
  BlackColor
};


MakeDialog
{
	-- Name the modal dialog
	name="creditswindow",
	Bitmap
	{
		image = "backgrounds/fullscreendialog",

		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=35,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "credits"
		};
		
		Bitmap
		{
			image = "backgrounds/credit_screen",
			mask = exists("backgrounds/credit_screen.mask.png"),
		};

		TCredits
		{
			x = 0, y = 127,
			w = 800, h = 365,
			font = standardFont,
			fontsize = 16,
			fontcolor = BlackColor,
			headercolor = DarkBlueColor,
			columngap = 50,
			columnwidth = 325,
			time = 20000, 		-- Time to play credits in milliseconds
			intropause = 3000, 	-- Time to pause credits at start, in ms
			file = "credits/credits.txt",
		},

		Text
		{
			flags=kHAlignCenter + kVAlignTop,
			x=0,y=-20,
			w=kMax;h=39;
			label="#"..GetString("version",GetConfig(kGameVersion)) ;
		};

		Button
		{
			x=kCenter,
			y=kMax-85,
			font = ThinButtonFont,
			graphics = ThinButtonGraphics,
			name="back",
			type = kPush,
			flags = kHAlignCenter + kVAlignCenter,
			label="back",
			command =
				function()
					PopModal("creditswindow");
				end
		};
	},
}